package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.VfichaOs2Dao;
import com.ejie.ab04b.model.VfichaOs2;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VfichaOs2ServiceImpl generated by UDA, 27-jun-2017 10:39:49.
 * 
 * @author UDA
 */

@Service(value = "vfichaOs2Service")
public class VfichaOs2ServiceImpl implements VfichaOs2Service {

	@Autowired
	private VfichaOs2Dao vfichaOs2Dao;

	/**
	 * Inserts a single row in the VfichaOs2 table.
	 * 
	 *  vfichaOs2
	 *            VfichaOs2
	 *  VfichaOs2
	 *
	 * @param vfichaOs2 the vficha os 2
	 * @return the vficha os 2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VfichaOs2 add(VfichaOs2 vfichaOs2) {
		return this.vfichaOs2Dao.add(vfichaOs2);
	}

	/**
	 * Updates a single row in the VfichaOs2 table.
	 * 
	 *  vfichaOs2
	 *            VfichaOs2
	 *  VfichaOs2
	 *
	 * @param vfichaOs2 the vficha os 2
	 * @return the vficha os 2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VfichaOs2 update(VfichaOs2 vfichaOs2) {
		return this.vfichaOs2Dao.update(vfichaOs2);
	}

	/**
	 * Finds a single row in the VfichaOs2 table.
	 * 
	 *  vfichaOs2
	 *            VfichaOs2
	 *  VfichaOs2
	 *
	 * @param vfichaOs2 the vficha os 2
	 * @return the vficha os 2
	 */
	public VfichaOs2 find(VfichaOs2 vfichaOs2) {
		return (VfichaOs2) this.vfichaOs2Dao.find(vfichaOs2);
	}

	/**
	 * Deletes a single row in the VfichaOs2 table.
	 * 
	 *  vfichaOs2
	 *            VfichaOs2
	 *
	 * @param vfichaOs2 the vficha os 2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(VfichaOs2 vfichaOs2) {
		this.vfichaOs2Dao.remove(vfichaOs2);
	}

	/**
	 * Finds a list of rows in the VfichaOs2 table.
	 * 
	 *  vfichaOs2
	 *            VfichaOs2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VfichaOs2>
	 *
	 * @param vfichaOs2 the vficha os 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<VfichaOs2> findAll(VfichaOs2 vfichaOs2,
			JQGridRequestDto jqGridRequestDto) {
		return (List<VfichaOs2>) this.vfichaOs2Dao.findAll(vfichaOs2,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the VfichaOs2 table using like.
	 * 
	 *  vfichaOs2
	 *            VfichaOs2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VfichaOs2>
	 *
	 * @param vfichaOs2 the vficha os 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<VfichaOs2> findAllLike(VfichaOs2 vfichaOs2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<VfichaOs2>) this.vfichaOs2Dao.findAllLike(vfichaOs2,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the VfichaOs2 table.
	 * 
	 *  filterVfichaOs2
	 *            VfichaOs2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterVfichaOs2 the filter vficha os 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(VfichaOs2 filterVfichaOs2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.vfichaOs2Dao.removeMultiple(filterVfichaOs2, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the VfichaOs2 table.
	 * 
	 *  filterVfichaOs2
	 *            VfichaOs2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<VfichaOs2>
	 *
	 * @param filterVfichaOs2 the filter vficha os 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<VfichaOs2> filter(VfichaOs2 filterVfichaOs2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<VfichaOs2> listaVfichaOs2 = this.vfichaOs2Dao.findAllLike(
				filterVfichaOs2, jqGridRequestDto, false);
		Long recordNum = this.vfichaOs2Dao.findAllLikeCount(
				filterVfichaOs2 != null ? filterVfichaOs2 : new VfichaOs2(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<VfichaOs2>> reorderSelection = this.vfichaOs2Dao
					.reorderSelection(filterVfichaOs2, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<VfichaOs2>(jqGridRequestDto,
					recordNum, listaVfichaOs2, reorderSelection);
		}
		return new JQGridResponseDto<VfichaOs2>(jqGridRequestDto, recordNum,
				listaVfichaOs2);
	}

	/**
	 * Searches rows in the VfichaOs2 table.
	 * 
	 *  filterVfichaOs2
	 *            VfichaOs2
	 *  searchVfichaOs2
	 *            VfichaOs2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<VfichaOs2>>
	 *
	 * @param filterVfichaOs2 the filter vficha os 2
	 * @param searchVfichaOs2 the search vficha os 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<VfichaOs2>> search(VfichaOs2 filterVfichaOs2,
			VfichaOs2 searchVfichaOs2, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.vfichaOs2Dao.search(filterVfichaOs2, searchVfichaOs2,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in VfichaOs2 table.
	 * 
	 *  filterVfichaOs2
	 *            VfichaOs2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterVfichaOs2 the filter vficha os 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(VfichaOs2 filterVfichaOs2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.vfichaOs2Dao.reorderSelection(filterVfichaOs2,
				jqGridRequestDto, startsWith);
	}

}
